#include <p30fxxxx.h>
#include <xlcd.h>

/*External LCD functions are only defined for the following devices */
#if defined(__dsPIC30F5011__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6010__) || \
    defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__)

/*******************************************************************
Function Name :         WriteCmdXLCD
Description:            This function write a command to the 
                        Instruction Register of the LCD controller.
                        The user must first check if the controller 
                        is busy or not by calling the BusyXLCD()
                        function.
Input parameters:       char cmd
Return value:           void
********************************************************************/

void WriteCmdXLCD(char cmd)
{

    RW_PIN = 0;   /* enable write */
    RS_PIN = 0;   /* select Instruction Reg */

    /* configure the common data pins as output */
    TRIS_DATA_PIN_7 = 0;
    TRIS_DATA_PIN_6 = 0;
    TRIS_DATA_PIN_5 = 0;
    TRIS_DATA_PIN_4 = 0;

    DATA_PIN_7 = (unsigned int)((cmd & 0x80)>>7);
    DATA_PIN_6 = (unsigned int)((cmd & 0x40)>>6);
    DATA_PIN_5 = (unsigned int)((cmd & 0x20)>>5);
    DATA_PIN_4 = (unsigned int)((cmd & 0x10)>>4);

# ifdef EIGHT_BIT_INTERFACE
    /* configure the other pins as output */
    TRIS_DATA_PIN_3 = 0;
    TRIS_DATA_PIN_2 = 0;
    TRIS_DATA_PIN_1 = 0;
    TRIS_DATA_PIN_0 = 0;

    DATA_PIN_3 = (unsigned int)((cmd & 0x08)>>3);
    DATA_PIN_2 = (unsigned int)((cmd & 0x04)>>2);
    DATA_PIN_1 = (unsigned int)((cmd & 0x02)>>1);
    DATA_PIN_0 = (unsigned int)(cmd & 0x01);

    E_PIN = 1;
    Delay18Tcy();
    E_PIN = 0;
# else
    E_PIN = 1;
    Delay18Tcy();
    E_PIN = 0;

    RW_PIN = 0;  /* enable write */
    RS_PIN = 0;  /* select Instruction Reg */

    DATA_PIN_7 = (unsigned int)((cmd & 0x08)>>3);
    DATA_PIN_6 = (unsigned int)((cmd & 0x04)>>2);
    DATA_PIN_5 = (unsigned int)((cmd & 0x02)>>1);
    DATA_PIN_4 = (unsigned int)(cmd & 0x01);

    E_PIN = 1;
    Delay18Tcy();
    E_PIN = 0;
#endif

    /* configure all pins to input mode */
    TRIS_DATA_PIN_7 = 1;
    TRIS_DATA_PIN_6 = 1;
    TRIS_DATA_PIN_5 = 1; 
    TRIS_DATA_PIN_4 = 1;
#ifdef EIGHT_BIT_INTERFACE
    TRIS_DATA_PIN_3 = 1;
    TRIS_DATA_PIN_2 = 1;
    TRIS_DATA_PIN_1 = 1; 
    TRIS_DATA_PIN_0 = 1;
#endif
}  /* end of function */

#endif
/* end of file */
